{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 26.09.98 - 20:39:33 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  ShellAPI,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  ExtCtrls,
  Menus,
  MMAbout,
  MMObj,
  MMAVICtl,
  MMCstDlg,
  MMAVI,
  MMHook,
  MMDesign;

type
  TMainForm = class(TForm)
    AVIFile: TMMAVIFile;
    AVIOpenDialog: TMMAVIOpenDialog;
    AVIControl: TMMAVIControl;
    AVIDisplay: TMMAVIVideoDisplay;
    Bevel1: TBevel;
    PopupMenu1: TPopupMenu;
    OpenFile1: TMenuItem;
    N1: TMenuItem;
    Play1: TMenuItem;
    Pause1: TMenuItem;
    Stop1: TMenuItem;
    N2: TMenuItem;
    ShowDisplay1: TMenuItem;
    ShowControls1: TMenuItem;
    N3: TMenuItem;
    Properties1: TMenuItem;
    N4: TMenuItem;
    Info1: TMenuItem;
    MMDesigner1: TMMDesigner;
    N5: TMenuItem;
    SaveFrame1: TMenuItem;
    SaveDialog: TSaveDialog;
    procedure AVIDisplayDblClick(Sender: TObject);
    procedure OpenFile1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Play1Click(Sender: TObject);
    procedure Pause1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure ShowDisplay1Click(Sender: TObject);
    procedure ShowControls1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SaveFrame1Click(Sender: TObject);
  private
    MinWidth,MinHeight: integer;
    procedure WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure SetminMax;
  end;

var
  MainForm: TMainForm;

implementation

uses Unit2;

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo);
begin
   if (MinWidth <> 0) then
   begin
      with Msg.MinMaxInfo^ do
      begin
         ptMinTrackSize.X := MinWidth;   { Minimum width  }
         ptMinTrackSize.Y := MinHeight;  { Minimum height }
      end;
      Msg.Result := 0;       { Tell windows you have changed minmaxinfo }
   end;

   inherited;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SetMinMax;
begin
   MinWidth := (Width-ClientWidth)+AVIControl.MinWidth;
   MinHeight:= (Height-ClientHeight)+AVIControl.MinHeight;

   if Height < MinHeight then Height := MinHeight;

   with AVIControl do
   begin
      if (not ShowDisplay and not ShowControls) then
      begin
         Bevel1.Visible := False;
         AVIControl.Visible := False;
      end
      else
      begin
         AVIControl.Visible := True;
         Bevel1.Visible := True;
         Bevel1.Top := 0;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormResize(Sender: TObject);
begin
   if Height <= MinHeight then
      Bevel1.Visible := False
   else
   with AVIControl do
   if (AVIControl.ShowDisplay and ShowControls) then
   begin
      Bevel1.Visible := True;
      Bevel1.Top := 0;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   MinWidth := 0;
   Icon.Handle := LoadIcon(0,IDI_WINLOGO);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   SetMinMax;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   AVIControl.FreeStreams;
   AVIFile.CloseFile;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PopupMenu1Popup(Sender: TObject);
begin
   with AVIControl do
   begin
      Play1.Enabled := (hasAudio or hasVideo) and not Playing or Paused;
      Pause1.Enabled := Playing and not Paused;
      Stop1.Enabled := Playing;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.OpenFile1Click(Sender: TObject);
var
   Idx: WORD;

begin
   if AVIOpenDialog.Execute then
   begin
      AVIFile.FileName := AVIOpenDialog.FileName;
      Caption := ExtractFileName(AVIOpenDialog.FileName);
      AVIFile.OpenFile;
      AVIControl.FreeStreams;
      AVIControl.AddFile(AVIFile);

      AVIDisplay.Refresh;

      Icon.Handle := ExtractassociatedIcon(0,PChar(AVIOpenDialog.FileName),Idx);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.AVIDisplayDblClick(Sender: TObject);
begin
   with AVIControl do
   if hasAudio or hasVideo then
   begin
      if not Playing or Paused then Play
      else Stop;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Play1Click(Sender: TObject);
begin
   AVIControl.Play;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Pause1Click(Sender: TObject);
begin
   AVIControl.Pause;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Stop1Click(Sender: TObject);
begin
   AVIControl.Stop;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ShowDisplay1Click(Sender: TObject);
begin
   with AVIControl do
   begin
      ShowDisplay := not ShowDisplay;
      ShowDisplay1.Checked := ShowDisplay;
      SetMinMax;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ShowControls1Click(Sender: TObject);
begin
   with AVIControl do
   begin
      ShowControls := not ShowControls;
      ShowControls1.Checked := ShowControls;
      SetMinMax;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Properties1Click(Sender: TObject);
begin
   with TPreferencesForm.Create(Self) do
   try
      ShowModal;
   finally
      Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.Info1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SaveFrame1Click(Sender: TObject);
var
   Bmp: TBitmap;
begin
   if SaveDialog.Execute then
   begin
      // make sure the display is up-to-date
      AVIDisplay.Refresh;

      Bmp := TBitmap.Create;
      try
         Bmp.Width := AVIDisplay.Width-2*AVIDisplay.BevelExtend;
         Bmp.Height:= AVIDisplay.Height-2*AVIDisplay.BevelExtend;
         Bmp.Canvas.CopyRect(Rect(0,0,Bmp.Width,Bmp.Height),
                             AVIDisplay.Canvas,
                             AVIDisplay.BeveledRect);

         Bmp.SaveToFile(SaveDialog.FileName);

      finally
         Bmp.Free;
      end;
   end;
end;

end.

